(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     21841,        655]*)
(*NotebookOutlinePosition[     22641,        685]*)
(*  CellTagsIndexPosition[     22568,        679]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Ejercicio 1", "Subsection"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " Calcula las normales a la hip\[EAcute]rbola  ",
  Cell[BoxData[
      \(TraditionalForm\`x\ y = 1\)]],
  " que pasan por el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(-1\), 1)\)\)]],
  ". Haz una representaci\[OAcute]n gr\[AAcute]fica.\n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " Calcula las normales a la gr\[AAcute]fica de  ",
  Cell[BoxData[
      \(TraditionalForm\`y = 2\ x\^3 + 13  x\^2 + 5  x + 9\)]],
  "  que pasan por el origen. Haz una representaci\[OAcute]n \
gr\[AAcute]fica."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Soluci\[OAcute]n", "Subsection"],

Cell[TextData[{
  "Este ejercicio es el ",
  StyleBox["mismo",
    FontSlant->"Italic"],
  " ejercicio n\[UAcute]mero 2 de la pr\[AAcute]ctica 5 en el que se ha \
sustituido \"tangente\" por \"normal\". Lo primero es definir la recta \
normal, cosa que muchos de vosotros no sab\[EAcute]is hacer. La recta de \
ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm
      \`y = f \((a)\) - \(1\/\(f\ ' \((a)\)\)\) \((x - a)\)\)]],
  " es la normal a la gr\[AAcute]fica de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, f \((a)\))\)\)]],
  ". La ",
  StyleBox["funci\[OAcute]n",
    FontSlant->"Italic"],
  " cuya ",
  StyleBox["gr\[AAcute]fica",
    FontSlant->"Italic"],
  " es la recta normal es la siguiente."
}], "Text"],

Cell[BoxData[
    \(\(\(normal[f_, a_]\)[x_] := f[a] - \(1\/\(f'\)[a]\) \((x - a)\)\ \)\)], 
  "Input"],

Cell[TextData[{
  "Muchos de vosostros todav\[IAcute]a confund\[IAcute]s una funci\[OAcute]n \
con su gr\[AAcute]fica. La raz\[OAcute]n de este error est\[AAcute] en que en \
las ense\[NTilde]anzas medias es usual usar la expresi\[OAcute]n \"sea la \
funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`y = f(x)\)]],
  "\" (yo mismo la uso a veces). Propiamente hablando, una igualdad del tipo \
",
  Cell[BoxData[
      \(TraditionalForm\`y = f(x)\)]],
  " no es una funci\[OAcute]n, representa el conjunto de puntos del plano ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " tales que ",
  Cell[BoxData[
      \(TraditionalForm\`y = f(x)\)]],
  ", es decir, representa la gr\[AAcute]fica de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ". Una cosa es la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`x \[RightTeeArrow] f(x)\)]],
  " y otra su gr\[AAcute]fica. De esa confusi\[OAcute]n proceden muchos \
errores. Por supuesto, si en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " defines ",
  Cell[BoxData[
      \(TraditionalForm\`y = f \((x)\)\)]],
  " lo que est\[AAcute]s haciendo es atribuir el s\[IAcute]mbolo ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " a ",
  Cell[BoxData[
      \(TraditionalForm\`f(x)\)]],
  ", nada m\[AAcute]s. No est\[AAcute]s definiendo una funci\[OAcute]n. Esta \
forma de proceder puede dar lugar a errores."
}], "Text"],

Cell[BoxData[{
    \(y = x^3;  (*\ 
      Mathematica\ sustituir\[AAcute]\ el\ s\[IAcute]mbolo\ y\ por\ x^3\ *) \n
    y\  (*\ y\ es\ x^3\ *) \), 
    \(y' (*\ no\ puedes\ derivar\ y\ porque\ NO\ es\ una\ funci\[OAcute]n, \ 
      es\ como\ si\ escribieras\ \((x\^3)\)'\ *) \)}], "Input"],

Cell[TextData[{
  "Recuerda, en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " las funciones hay que definirlas como se estudi\[OAcute] en la primera pr\
\[AAcute]ctica."
}], "Text"],

Cell[TextData[{
  "Ahora hay que calcular ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " por la condici\[OAcute]n de que la recta normal ",
  Cell[BoxData[
      \(TraditionalForm
      \`y = f \((a)\) - \(1\/\(f\ ' \((a)\)\)\) \((x - a)\)\)]],
  " pase por el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(-1\), 1)\)\)]],
  "; o sea, que se verifique que ",
  Cell[BoxData[
      \(TraditionalForm
      \`1 = f \((a)\) - \(1\/\(f\ ' \((a)\)\)\) \((\(-1\) - a)\)\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(f[x_] = 1\/x; \nsol = a /. Solve[\(normal[f, a]\)[\(-1\)] == 1, a]\)], 
  "Input"],

Cell["Solamente interesan las soluciones reales.", "Text"],

Cell[BoxData[
    \({a, b} = {sol[\([3]\)], sol[\([4]\)]}\)], "Input"],

Cell["Finalmente, hacemos la representaci\[OAcute]n gr\[AAcute]fica.", "Text"],

Cell[BoxData[
    \(\(Plot[{1/x, \(normal[f, a]\)[x], \(normal[f, b]\)[x]}, {x, \(-3\), 2}, 
      PlotRange -> {\(-3\), 5}, AspectRatio -> Automatic, 
      Epilog -> {Hue[0], PointSize[ .03], \ Point[{a, f[a]}], \ 
          Point[{b, f[b]}], Hue[ .65], Point[{\(-1\), 1}]}]; \)\)], "Input"],

Cell["Ahora hay que repetir lo mismo con otra funci\[OAcute]n.", "Text"],

Cell[BoxData[{
    \(g[x_] = 2\ x\^3 + 13  x\^2 + 5  x + 9; \nClear[a, b]\), 
    \(newsol = a /. NSolve[\(normal[g, a]\)[0] == 0, a]\)}], "Input"],

Cell[BoxData[
    \({a, b, c} = Table[newsol[\([k]\)], {k, 1, 3}]\)], "Input"],

Cell[BoxData[
    \(\(Plot[{g[x], \(normal[g, a]\)[x], \(normal[g, b]\)[x], 
        \(normal[g, c]\)[x]}, {x, \(-7\), 1}, PlotRange -> {\(-10\), 80}, 
      Epilog -> {Hue[0], PointSize[ .02], \ Point[{a, g[a]}], \ 
          Point[{b, g[b]}], \ Point[{c, g[c]}], Hue[ .65], Point[{0, 0}]}]; 
    \)\)], "Input"],

Cell[BoxData[
    \(Clear["\<@\>"]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Subsection"],

Cell[TextData[StyleBox[
" Calcular el \[AAcute]rea de la regi\[OAcute]n com\[UAcute]n a las dos \
elipses ",
  FontWeight->"Plain"]], "Text"],

Cell[BoxData[
    FormBox[
      StyleBox[
        RowBox[{
          RowBox[{
            RowBox[{
              FractionBox[\(x\^2\), 
                StyleBox["16",
                  FontWeight->"Plain"]], "+", 
              FractionBox[\(y\^2\), 
                StyleBox["4",
                  FontWeight->"Plain"]]}], "=", "1"}], ",", "           ", 
          RowBox[{
            RowBox[{
              FractionBox[\(x\^2\), 
                StyleBox["4",
                  FontWeight->"Plain"]], "+", 
              FractionBox[\(y\^2\), 
                StyleBox["16",
                  FontWeight->"Plain"]]}], "=", "1"}]}],
        FontWeight->"Plain"], TraditionalForm]], "Text",
  TextAlignment->Center]
}, Open  ]],

Cell[CellGroupData[{

Cell["Soluci\[OAcute]n", "Subsection"],

Cell["\<\
Este ejercicio lo hicimos en clase de dos formas: usando coordenadas \
cartesianas y usando coordenadas polares. Hacemos una representaci\[OAcute]n \
gr\[AAcute]fica para visualizar la regi\[OAcute]n cuya \[AAcute]rea queremos \
calcular. Como son curvas cerradas, lo mejor es usar sus ecuaciones param\
\[EAcute]tricas. \
\>", "Text"],

Cell[BoxData[
    \(\(ParametricPlot[{{4\ Cos[t], 2\ Sin[t]}, {2\ Cos[t], 4\ Sin[t]}}, {t, 
        0, 2  Pi}, PlotStyle -> {Hue[0], Hue[ .7]}, 
      AspectRatio -> Automatic]; \)\)], "Input"],

Cell[TextData[{
  "La regi\[OAcute]n com\[UAcute]n a las dos elipses es la que quedfa dentro \
de ambas. Por la simetr\[IAcute]a, basta calcular el \[AAcute]rea de la parte \
de dicha regi\[OAcute]n que queda en el primer cuadrante. ",
  "Expresamos ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " como funci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "."
}], "Text"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"y", "/.", 
        RowBox[{"Solve", "[", 
          RowBox[{
            RowBox[{
              RowBox[{
                FractionBox[\(x\^2\), 
                  StyleBox["16",
                    FontWeight->"Plain"]], "+", 
                FractionBox[\(y\^2\), 
                  StyleBox["4",
                    FontWeight->"Plain"]]}], "==", "1"}], ",", "y"}], 
          "]"}]}], \( (*\ la\ elipse\ en\ rojo\ *) \)}], 
    RowBox[{
      RowBox[{"y", "/.", 
        RowBox[{"Solve", "[", 
          RowBox[{
            RowBox[{
              RowBox[{
                FractionBox[\(x\^2\), 
                  StyleBox["4",
                    FontWeight->"Plain"]], "+", 
                FractionBox[\(y\^2\), 
                  StyleBox["16",
                    FontWeight->"Plain"]]}], "==", "1"}], ",", "y"}], 
          "]"}]}], \( (*\ la\ elipse\ en\ azul\ *) \)}]}], "Input"],

Cell["Calculamos las abscisas de los puntos de corte.", "Text"],

Cell[BoxData[
    \(x /. Solve[\@\(16 - x\^2\)\/2 == 2\ \@\(4 - x\^2\), x]\)], "Input"],

Cell["\<\
Podemos representar (aunque no es preciso) con m\[AAcute]s detalle la parte \
de la regi\[OAcute]n cuya \[AAcute]rea queremos calcular.\
\>", "Text"],

Cell[BoxData[
    \(graf1 = 
      Plot[\@\(16 - x\^2\)\/2, {x, 0, 4\/\@5}, PlotStyle -> Hue[0], 
        Epilog -> {Hue[ .12], 
            Line[{{4\/\@5, 0}, {4\/\@5, 
                  \@\(16 - x\^2\)\/2 /. x -> 4\/\@5}}]}, 
        DisplayFunction -> Identity]\  (*\ parte\ de\ una\ elipse\ *) ; \n
    graf2 = Plot[2\ \@\(4 - x\^2\), {x, 4\/\@5, 2}, PlotStyle -> Hue[ .7], 
        DisplayFunction -> Identity] (*\ parte\ de\ la\ otra\ elipse\ *) ; \n
    Show[{graf1, graf2, 
        Graphics[{Text[\[CapitalOmega]\_1, { .9,  .9}], 
            Text[\[CapitalOmega]\_2, {1.9,  .45}], 
            Text[y = \@\(16 - x\^2\)\/2, {0.6, 1.8}], 
            Text[y = 2\ \@\(4 - x\^2\), {2.25,  .85}]}]}, 
      DisplayFunction -> $DisplayFunction, 
      PlotRange -> {{\(-0.2\), 2.6}, {\(- .2\), 2}}, 
      Ticks -> {{4\/\@5, 2}, Automatic}, AspectRatio -> Automatic, 
      TextStyle -> {FontFamily\  -> \ "\<Times\>", \ FontSize\  -> \ 10}]; 
    \)], "Input"],

Cell["El valor exacto del \[AAcute]rea pedida es:", "Text"],

Cell[BoxData[{
    \(4*Simplify[
        Integrate[\@\(16 - x\^2\)\/2, {x, 0, 4\/\@5}]\  (*\ 
            \[AAcute]rea\ de\ \[CapitalOmega]\_\(1\ \)*) \ \n\t\t\t\t + 
          Integrate[2\ \@\(4 - x\^2\), {x, 4\/\@5, 2}]\  (*\ 
          \[AAcute]rea\ de\ \[CapitalOmega]\_\(2\ \)*) \ ]\), 
    \(N[%]\)}], "Input"],

Cell["\<\
Otra forma de proceder, quiz\[AAcute]s m\[AAcute]s sencilla, para calcular el \
\[AAcute]rea de la zona pedida, consiste en calcular el \[AAcute]rea limitada \
por la parte superior de la elipse azul y restarle el \[AAcute]rea de la regi\
\[OAcute]n limitada por la parte superior de la elipse azul y la parte \
superior de la elipse roja.\
\>", "Text"],

Cell[BoxData[
    \(2*\((
          Integrate[2\ \@\(4 - x\^2\), {x, \(-2\), 2}] - 
            Integrate[
              2\ \@\(4 - x\^2\) - \@\(16 - x\^2\)\/2, {x, \(-\(4\/\@5\)\), 
                4\/\@5}])\) // Simplify\)], "Input"],

Cell["Podemos hacer este ejercicio usando coordenadas polares.", "Text"],

Cell[BoxData[
    \(Clear["\<@\>"]\)], "Input"],

Cell["\<\
Expresamos las ecuaciones de las elipses en coordenadas polares.\
\>", "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            RowBox[{
              FractionBox[\(x\^2\), 
                StyleBox["16",
                  FontWeight->"Plain"]], "+", 
              FractionBox[\(y\^2\), 
                StyleBox["4",
                  FontWeight->"Plain"]]}], "==", "1"}], ",", 
          RowBox[{
            RowBox[{
              FractionBox[\(x\^2\), 
                StyleBox["4",
                  FontWeight->"Plain"]], "+", 
              FractionBox[\(y\^2\), 
                StyleBox["16",
                  FontWeight->"Plain"]]}], "==", "1"}]}], "}"}], "/.", 
      \({x -> r\ Cos[t], y -> r\ Sin[t]}\)}]], "Input"],

Cell[TextData[{
  "Despejamos ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " (el radio polar) en funci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " (la medida en radianes del \[AAcute]ngulo polar). Selecciono las \
soluciones positivas."
}], "Text"],

Cell[BoxData[{
    \(r1[t_] = 
      r /. \(Solve[1\/16\ r\^2\ Cos[t]\^2 + 1\/4\ r\^2\ Sin[t]\^2 == 1, r]\)[
          \([2]\)]\), 
    \(r2[t_] = 
      r /. \(Solve[1\/4\ r\^2\ Cos[t]\^2 + 1\/16\ r\^2\ Sin[t]\^2 == 1, r]\)[
          \([2]\)]\)}], "Input"],

Cell["\<\
Representemos las gr\[AAcute]ficas usando estas ecuaciones. Debemos usar \
PlarPlot[ ].\
\>", "Text"],

Cell["<< Graphics`Graphics`", "Input",
  CellTags->"S5.36.1"],

Cell[BoxData[
    \(\(PolarPlot[{r1[t], r2[t]}, {t, 0, 2  Pi}, 
      PlotStyle -> {Hue[0], Hue[ .7]}]; \)\)], "Input"],

Cell["Calculemos los puntos de corte.", "Text"],

Cell[BoxData[
    \(t /. Solve[r1[t] == r2[t], t]\)], "Input"],

Cell[TextData[{
  "Los mensajes de error no tienen importancia pues est\[AAcute] claro que el \
punto que buscamos es ",
  Cell[BoxData[
      \(TraditionalForm\`t = \[Pi]\/4\)]],
  ". Podemos representar de nuevo la regi\[OAcute]n que nos interesa."
}], "Text"],

Cell[BoxData[
    \(gr1 = 
      PolarPlot[r1[t], {t, Pi/4, Pi/2}, PlotStyle -> Hue[0], 
        DisplayFunction -> Identity]\n (*\ parte\ de\ una\ elipse\ *) ; \n
    gr2 = PolarPlot[r2[t], {t, 0, Pi/4}, PlotStyle -> Hue[ .7], 
        DisplayFunction -> Identity]\n (*\ parte\ de\ otra\ elipse\ *) ; \n
    Show[{gr1, gr2, 
        Graphics[{Circle[{0, 0},  .3, {0, \[Pi]\/4}], 
            Text[45\^o, { .37,  .14}], Text[\[CapitalOmega]\_2, { .7, 1.4}], 
            Text[\[CapitalOmega]\_1, {1.4,  .7}], Hue[ .12], 
            Line[{{0, 0}, {r1[\[Pi]\/4] Cos[\[Pi]\/4], 
                  r1[\[Pi]\/4] Sin[\[Pi]\/4]}}]}]}, 
      TextStyle -> {FontFamily\  -> \ "\<Times\>", \ FontSize\  -> \ 12}, 
      Ticks -> None, DisplayFunction -> $DisplayFunction]; \)], "Input"],

Cell["El valor exacto del \[AAcute]rea pedida es:", "Text"],

Cell[BoxData[{
    \(4*Simplify[
        Integrate[\(1\/2\) r2[t]^2, {t, 0, \[Pi]\/4}]\  (*\ 
            \[AAcute]rea\ de\ \[CapitalOmega]\_\(1\ \)*) \  + \ \ \n\t\t\t\t
          Integrate[\(1\/2\) r1[t]^2, {t, \[Pi]\/4, \[Pi]\/2}]\  (*\ 
          \[AAcute]rea\ de\ \[CapitalOmega]\_2\ *) ]\), 
    \(N[%]\)}], "Input"],

Cell["\<\
Finalmente, podemos tambi\[EAcute]n calcular el \[AAcute]rea usando las \
ecuaciones param\[EAcute]tricas de la curva cerrada que rodea la \
regi\[OAcute]n cuya \[AAcute]rea se nos pide. Para ello, lo primero es \
calcular los valores de los par\[AAcute]metros que corresponden a los puntos \
de corte.\
\>", "Text"],

Cell[BoxData[{
    \(sol = {s, t} /. 
        Solve[{2  Cos[t], 4\ Sin[t]} == {4  Cos[s], 2  Sin[s]}, {s, t}]\), 
    \({{\[Alpha]2, \[Beta]2}, {\[Alpha]1, \[Beta]1}} = N[%]\)}], "Input"],

Cell["Comprobamos los resultados obtenidos.", "Text"],

Cell[BoxData[{
    \(Map[{2  Cos[#], 4  Sin[#]}&, {\[Beta]1, \[Beta]2}]\), 
    \(Map[{4  Cos[#], 2  Sin[#]}&, {\[Alpha]1, \[Alpha]2}]\)}], "Input"],

Cell[TextData[{
  "Solamente obtenemos as\[IAcute] los puntos de corte en el semiplano \
superior (lo que confirma que estamos perdiendo soluciones como nos advierte \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " en su mensaje)."
}], "Text"],

Cell[BoxData[
    \({u[t_], v[t_]} = {2  Cos[t], 4  Sin[t]}; 
    \n{z[t_], w[t_]} = {4  Cos[t], 2  Sin[t]}; \)], "Input"],

Cell[BoxData[
    \(a = 
      ParametricPlot[{u[t], v[t]}, {t, \(-\[Beta]1\), \[Beta]1}, 
        PlotStyle -> {Hue[0], Thickness[ .005]}, 
        DisplayFunction -> Identity]; \n
    b = ParametricPlot[{z[t], w[t]}, {t, \[Alpha]1, \[Alpha]2}, 
        PlotStyle -> {Hue[0.25], Thickness[ .0075]}, 
        DisplayFunction -> Identity]; \n
    c = ParametricPlot[{u[t], v[t]}, {t, Pi - \[Beta]1, Pi + \[Beta]1}, 
        PlotStyle -> {Hue[0.5], Thickness[ .01]}, 
        DisplayFunction -> Identity]; \n
    d = ParametricPlot[{z[t], w[t]}, {t, Pi + \[Alpha]1, Pi + \[Alpha]2}, 
        PlotStyle -> {Hue[0.75], Thickness[ .0125]}, 
        DisplayFunction -> Identity]; \n
    Show[{a, b, c, d}, DisplayFunction -> $DisplayFunction]; \)], "Input"],

Cell[BoxData[
    \(Integrate[u[t] \(v'\)[t], {t, \(-\[Beta]1\), \[Beta]1}] + 
        Integrate[z[t] \(w'\)[t], {t, \[Alpha]1, \[Alpha]2}] + 
        Integrate[u[t] \(v'\)[t], {t, Pi - \[Beta]1, Pi + \[Beta]1}] + 
        Integrate[z[t] \(w'\)[t], {t, Pi + \[Alpha]1, Pi + \[Alpha]2}] // 
      Simplify\)], "Input"],

Cell[BoxData[
    \(Clear["\<@\>"]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Subsection"],

Cell[TextData[{
  StyleBox[
  " Calcular el volumen del s\[OAcute]lido \[CapitalOmega] engendrado al \
girar la regi\[OAcute]n limitada por las par\[AAcute]bolas ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SuperscriptBox[
              StyleBox["y",
                FontWeight->"Plain"], "2"], "=", "x"}], ",", " ", 
          \(x\^2 = y\)}], TraditionalForm]],
    FontWeight->"Plain"],
  StyleBox[" alrededor de la recta ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`x = 4\)]]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Soluci\[OAcute]n", "Subsection"],

Cell[TextData[{
  "Hemos hecho en clase un ejercicio igual o muy parecido a este. Observa que \
para que para que las dos igualdades ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SuperscriptBox[
              StyleBox["y",
                FontWeight->"Plain"], "2"], "=", "x"}], ",", " ", 
          \(x\^2 = y\)}], TraditionalForm]]],
  " tengan sentido debe ser ",
  Cell[BoxData[
      \(TraditionalForm\`\(x \[GreaterEqual] 0\ \)\)]],
  "e ",
  Cell[BoxData[
      \(TraditionalForm\`y \[GreaterEqual] 0\)]],
  ". Por tanto, la igualdad, ",
  Cell[BoxData[
      \(TraditionalForm\`y\^2 = x\)]],
  " equivale, por ser ",
  Cell[BoxData[
      \(TraditionalForm\`y \[GreaterEqual] 0\)]],
  ", a ",
  Cell[BoxData[
      \(TraditionalForm\`y = \@x\)]],
  ". Calculemos, aunque es evidente, d\[OAcute]nde se cortan las \
par\[AAcute]bolas. "
}], "Text"],

Cell[BoxData[
    \(x /. Solve[\@x == x^2, x]\)], "Input"],

Cell[TextData[{
  "Representemos la regi\[OAcute]n que vamos a girar alrededor de la recta ",
  Cell[BoxData[
      \(TraditionalForm\`x = 4\)]],
  " junto con una parte de dicha recta."
}], "Text"],

Cell[BoxData[
    \(\(Plot[{\@x, x^2}, {x, 0, 1}, Epilog -> Line[{{1, 1}, {4, 1}, {4, 0}}], 
      PlotRange -> {{\(- .1\), 4.5}, {\(- .1\), 1.1}}, 
      PlotStyle -> {Hue[0], Hue[ .65]}]; \)\)], "Input"],

Cell["\<\
La regi\[OAcute]n que giramos es la comprendida entre las dos \
par\[AAcute]bolas. Podemos calcular el volumen del cuerpo de \
revoluci\[OAcute]n resultante por el m\[EAcute]todo de los discos (arandelas \
en este caso) o por el m\[EAcute]todo de las l\[AAcute]minas o tubos. \
\>", "Text"],

Cell[TextData[{
  "Por el m\[EAcute]todo de los discos debemos integrar las \[AAcute]reas de \
secciones perpendiculares al eje de giro. Observa que debemos tomar como \
variable de integraci\[OAcute]n la variable ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ". La secci\[OAcute]n por una recta horizontal es una arandelas cuyo radio \
exterior es la distancia del eje de giro a la par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`y = \@x\)]],
  ", dicha distancia es  ",
  Cell[BoxData[
      \(TraditionalForm\`4 - x = 4 - y\^2\)]],
  "; y cuyo radio interior es la distancia del eje de giro a la \
par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\^2\)]],
  ", dicha distancia es  ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(4 - x\), "=", " ", 
          FormBox[\(4 - \@y\),
            "TraditionalForm"]}], TraditionalForm]]],
  ". Por tanto el volumen pedido es igual a:"
}], "Text"],

Cell[BoxData[
    \(Integrate[Pi\ \((\((4 - y\^2)\)\^2 - \((4 - \@y)\)\^2)\), {y, 0, 1}]
      \)], "Input"],

Cell[TextData[{
  "Para calcular el volumen por el m\[EAcute]todo de las l\[AAcute]minas o \
tubos debemos tomar como variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". Hay que tener en cuenta que cada segmento vertical que gira tiene de \
longitud  ",
  Cell[BoxData[
      \(TraditionalForm\`\@x - x\^2\)]],
  " (donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] x \[LessEqual] 1\)]],
  ") y el radio de giro es ",
  Cell[BoxData[
      \(TraditionalForm\`4 - x\)]],
  ". Por tanto el volumen es:"
}], "Text"],

Cell[BoxData[
    \(Integrate[2\ Pi\ \((4 - x)\) \((\@x - x^2)\), {x, 0, 1}]\)], "Input"]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 535}},
WindowSize->{771, 460},
WindowMargins->{{2, Automatic}, {Automatic, 2}},
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.36.1"->{
    Cell[13786, 418, 61, 1, 50, "Input",
      CellTags->"S5.36.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.36.1", 22473, 672}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 33, 0, 46, "Subsection"],
Cell[1767, 53, 581, 17, 60, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2385, 75, 38, 0, 46, "Subsection"],
Cell[2426, 77, 793, 24, 72, "Text"],
Cell[3222, 103, 103, 2, 64, "Input"],
Cell[3328, 107, 1440, 38, 105, "Text"],
Cell[4771, 147, 288, 5, 90, "Input"],
Cell[5062, 154, 194, 6, 29, "Text"],
Cell[5259, 162, 503, 16, 58, "Text"],
Cell[5765, 180, 102, 2, 83, "Input"],
Cell[5870, 184, 58, 0, 29, "Text"],
Cell[5931, 186, 70, 1, 50, "Input"],
Cell[6004, 189, 78, 0, 29, "Text"],
Cell[6085, 191, 293, 4, 90, "Input"],
Cell[6381, 197, 72, 0, 29, "Text"],
Cell[6456, 199, 147, 2, 90, "Input"],
Cell[6606, 203, 78, 1, 50, "Input"],
Cell[6687, 206, 313, 5, 90, "Input"],
Cell[7003, 213, 47, 1, 50, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7087, 219, 33, 0, 46, "Subsection"],
Cell[7123, 221, 141, 3, 29, "Text"],
Cell[7267, 226, 718, 21, 45, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8022, 252, 38, 0, 46, "Subsection"],
Cell[8063, 254, 345, 6, 48, "Text"],
Cell[8411, 262, 193, 3, 70, "Input"],
Cell[8607, 267, 397, 11, 48, "Text"],
Cell[9007, 280, 932, 26, 101, "Input"],
Cell[9942, 308, 63, 0, 29, "Text"],
Cell[10008, 310, 87, 1, 68, "Input"],
Cell[10098, 313, 159, 3, 29, "Text"],
Cell[10260, 318, 964, 18, 356, "Input"],
Cell[11227, 338, 59, 0, 29, "Text"],
Cell[11289, 340, 316, 6, 139, "Input"],
Cell[11608, 348, 363, 6, 48, "Text"],
Cell[11974, 356, 235, 5, 97, "Input"],
Cell[12212, 363, 72, 0, 29, "Text"],
Cell[12287, 365, 47, 1, 50, "Input"],
Cell[12337, 368, 88, 2, 29, "Text"],
Cell[12428, 372, 697, 20, 64, "Input"],
Cell[13128, 394, 280, 9, 29, "Text"],
Cell[13411, 405, 258, 6, 96, "Input"],
Cell[13672, 413, 111, 3, 29, "Text"],
Cell[13786, 418, 61, 1, 50, "Input",
  CellTags->"S5.36.1"],
Cell[13850, 421, 119, 2, 50, "Input"],
Cell[13972, 425, 47, 0, 29, "Text"],
Cell[14022, 427, 62, 1, 50, "Input"],
Cell[14087, 430, 262, 6, 51, "Text"],
Cell[14352, 438, 777, 13, 214, "Input"],
Cell[15132, 453, 59, 0, 29, "Text"],
Cell[15194, 455, 322, 6, 117, "Input"],
Cell[15519, 463, 326, 6, 48, "Text"],
Cell[15848, 471, 187, 3, 70, "Input"],
Cell[16038, 476, 53, 0, 29, "Text"],
Cell[16094, 478, 148, 2, 70, "Input"],
Cell[16245, 482, 255, 7, 48, "Text"],
Cell[16503, 491, 122, 2, 70, "Input"],
Cell[16628, 495, 751, 14, 210, "Input"],
Cell[17382, 511, 317, 5, 90, "Input"],
Cell[17702, 518, 47, 1, 50, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17786, 524, 33, 0, 46, "Subsection"],
Cell[17822, 526, 578, 18, 29, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18437, 549, 38, 0, 46, "Subsection"],
Cell[18478, 551, 890, 28, 48, "Text"],
Cell[19371, 581, 58, 1, 53, "Input"],
Cell[19432, 584, 198, 5, 29, "Text"],
Cell[19633, 591, 205, 3, 74, "Input"],
Cell[19841, 596, 300, 5, 48, "Text"],
Cell[20144, 603, 935, 24, 86, "Text"],
Cell[21082, 629, 108, 2, 57, "Input"],
Cell[21193, 633, 540, 16, 48, "Text"],
Cell[21736, 651, 89, 1, 53, "Input"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

